/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.tablelayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.Vector;
import uk.co.westhawk.tablelayout.TableCol;
import uk.co.westhawk.tablelayout.TableLoc;
import uk.co.westhawk.tablelayout.TableLocRec;
import uk.co.westhawk.tablelayout.TableRow;

public class TableLayout
implements LayoutManager,
Cloneable {
    private static final String version_id = "@(#)$Id: TableLayout.java,v 3.2 2001/03/22 13:15:01 birgit Exp $ Copyright West Consulting bv";
    boolean force_shrink = true;
    int col_spacing = 1;
    int row_spacing = 1;
    TableLoc layout = new TableLoc();
    Vector same_width = new Vector();
    Vector same_height = new Vector();
    int margin_width = 0;
    int margin_height = 0;
    TableCol cols = null;
    TableRow rows = null;

    public TableLayout() {
    }

    public TableLayout(int colSpacing, int rowSpacing) {
        this();
        this.col_spacing = colSpacing;
        this.row_spacing = rowSpacing;
    }

    public void addLayoutComponent(String name, Component comp) {
        try {
            TableLocRec rec = new TableLocRec(name);
            this.layout.addElement(rec, comp);
        }
        catch (Exception e) {
            System.out.println("TableLayout: Syntax error in component: " + name);
        }
    }

    public void removeLayoutComponent(Component comp) {
        this.layout.removeElement(comp);
        int index = this.same_width.indexOf(comp);
        if (index > -1) {
            this.same_width.removeElementAt(index);
        }
        if ((index = this.same_height.indexOf(comp)) > -1) {
            this.same_height.removeElementAt(index);
        }
    }

    public Dimension preferredLayoutSize(Container target) {
        int width = 0;
        int height = 0;
        Insets insets = target.getInsets();
        int nmembers = target.getComponentCount();
        if (nmembers > 0) {
            int i = 0;
            while (i < nmembers) {
                Component current = target.getComponent(i);
                TableLocRec rec = this.layout.element(current);
                if (rec == null) break;
                rec.orig_width = current.getPreferredSize().width;
                rec.orig_height = current.getPreferredSize().height;
                rec.same_width = 0;
                rec.same_height = 0;
                ++i;
            }
            this.considerSameWidth();
            this.considerSameHeight();
            this.cols = new TableCol(this);
            this.rows = new TableRow(this);
            width = this.cols.getPreferredSize() + insets.left + insets.right;
            height = this.rows.getPreferredSize() + insets.top + insets.bottom;
        }
        return new Dimension(width, height);
    }

    public Dimension minimumLayoutSize(Container target) {
        int width = 0;
        int height = 0;
        Insets insets = target.getInsets();
        int nmembers = target.getComponentCount();
        if (nmembers > 0) {
            int i = 0;
            while (i < nmembers) {
                Component current = target.getComponent(i);
                TableLocRec rec = this.layout.element(current);
                if (rec == null) break;
                rec.orig_width = current.getMinimumSize().width;
                rec.orig_height = current.getMinimumSize().height;
                rec.same_width = 0;
                rec.same_height = 0;
                ++i;
            }
            this.considerSameWidth();
            this.considerSameHeight();
            this.cols = new TableCol(this);
            this.rows = new TableRow(this);
            width = this.cols.totalSize() + insets.left + insets.right;
            height = this.rows.totalSize() + insets.top + insets.bottom;
        }
        return new Dimension(width, height);
    }

    public void layoutContainer(Container target) {
        Dimension dim = target.getSize();
        Insets insets = target.getInsets();
        int nmembers = target.getComponentCount();
        if (nmembers > 0) {
            int i = 0;
            while (i < nmembers) {
                Component current = target.getComponent(i);
                TableLocRec rec = this.layout.element(current);
                if (rec == null) break;
                current.doLayout();
                rec.orig_width = current.getPreferredSize().width;
                rec.orig_height = current.getPreferredSize().height;
                rec.same_width = 0;
                rec.same_height = 0;
                ++i;
            }
            this.considerSameWidth();
            this.considerSameHeight();
            this.cols = new TableCol(this);
            this.rows = new TableRow(this);
            this.cols.minimize();
            this.rows.minimize();
            this.tableMakeColsFitWidth(dim.width - insets.left - insets.right);
            this.tableMakeRowsFitHeight(dim.height - insets.top - insets.bottom);
            this.tableSetGeometryOfChildren(insets);
        }
    }

    public void sameWidth(Vector v) {
        this.same_width.addElement(v);
    }

    public void sameHeight(Vector v) {
        this.same_height.addElement(v);
    }

    public void marginWidth(int i) {
        this.margin_width = i;
    }

    public void marginHeight(int i) {
        this.margin_height = i;
    }

    public void forceShrink(boolean force) {
        this.force_shrink = force;
    }

    public void columnSpacing(int sp) {
        this.col_spacing = sp;
    }

    public void rowSpacing(int sp) {
        this.row_spacing = sp;
    }

    private void considerSameWidth() {
        int nlist = this.same_width.size();
        int ind1 = 0;
        while (ind1 < nlist) {
            Vector compv = (Vector)this.same_width.elementAt(ind1);
            int max = 0;
            int ncomp = compv.size();
            int ind2 = 0;
            while (ind2 < ncomp) {
                Component comp = (Component)compv.elementAt(ind2);
                TableLocRec rec = this.layout.element(comp);
                if (rec == null) break;
                if (rec.orig_width > max) {
                    max = rec.orig_width;
                }
                ++ind2;
            }
            int ind22 = 0;
            while (ind22 < ncomp) {
                Component comp = (Component)compv.elementAt(ind22);
                TableLocRec rec = this.layout.element(comp);
                if (rec == null) break;
                rec.same_width = max;
                ++ind22;
            }
            ++ind1;
        }
    }

    private void considerSameHeight() {
        int nlist = this.same_height.size();
        int ind1 = 0;
        while (ind1 < nlist) {
            Vector compv = (Vector)this.same_height.elementAt(ind1);
            int max = 0;
            int ncomp = compv.size();
            int ind2 = 0;
            while (ind2 < ncomp) {
                Component comp = (Component)compv.elementAt(ind2);
                TableLocRec rec = this.layout.element(comp);
                if (rec == null) break;
                if (rec.orig_height > max) {
                    max = rec.orig_height;
                }
                ++ind2;
            }
            int ind22 = 0;
            while (ind22 < ncomp) {
                Component comp = (Component)compv.elementAt(ind22);
                TableLocRec rec = this.layout.element(comp);
                if (rec == null) break;
                rec.same_height = max;
                ++ind22;
            }
            ++ind1;
        }
    }

    private void tableMakeColsFitWidth(int width) {
        int current = this.cols.totalSize();
        int prefer = this.cols.getPreferredSize();
        int change = width < prefer && !this.force_shrink ? prefer - current : width - current;
        if (change != 0) {
            this.cols.adjust(change);
        }
    }

    private void tableMakeRowsFitHeight(int height) {
        int current = this.rows.totalSize();
        int prefer = this.rows.getPreferredSize();
        int change = height < prefer && !this.force_shrink ? prefer - current : height - current;
        if (change != 0) {
            this.rows.adjust(change);
        }
    }

    private void tableSetGeometryOfChildren(Insets insets) {
        if (this.layout == (TableLoc)null || this.cols == (TableCol)null || this.rows == (TableRow)null) {
            return;
        }
        this.cols.computeOffsets(insets.left + this.margin_width, this.col_spacing);
        this.rows.computeOffsets(insets.top + this.margin_height, this.row_spacing);
        int sz = this.layout.size();
        int index = 0;
        while (index < sz) {
            TableLocRec rec = this.layout.recElementAt(index);
            Component comp = this.layout.compElementAt(index);
            this.TableComputeChildPosition(rec, comp);
            ++index;
        }
    }

    private void TableComputeChildPosition(TableLocRec rec, Component comp) {
        int pad = this.col_spacing;
        int cell_w = -pad;
        int i = 0;
        while (i < rec.col_span) {
            cell_w += this.cols.elementAt((int)(rec.col + i)).value + pad;
            ++i;
        }
        int prefer = rec.preferredWidth();
        int width = rec.options.W && cell_w > prefer ? prefer : cell_w;
        if (width <= 0) {
            width = 1;
        }
        pad = this.row_spacing;
        int cell_h = -pad;
        i = 0;
        while (i < rec.row_span) {
            cell_h += this.rows.elementAt((int)(rec.row + i)).value + pad;
            ++i;
        }
        prefer = rec.preferredHeight();
        int height = rec.options.H && cell_h > prefer ? prefer : cell_h;
        if (height <= 0) {
            height = 1;
        }
        int cell_x = this.cols.elementAt((int)rec.col).offset;
        int x = rec.options.l ? cell_x : (rec.options.r ? cell_x + cell_w - width : cell_x + (cell_w - width) / 2);
        int cell_y = this.rows.elementAt((int)rec.row).offset;
        int y = rec.options.t ? cell_y : (rec.options.b ? cell_y + cell_h - height : cell_y + (cell_h - height) / 2);
        comp.setSize(width, height);
        Point p = comp.getLocation();
        if (x != p.x || y != p.y) {
            comp.setLocation(x, y);
        }
    }

    public String toString() {
        String colsStr = this.cols != null ? this.cols.toString() : "null";
        String rowsStr = this.rows != null ? this.rows.toString() : "null";
        return "TableLayout [\nlayout: " + this.layout.toString() + "\ncols: " + colsStr + "\nrows: " + rowsStr + "\nsame_width: " + this.same_width.toString() + "\nsame_height: " + this.same_height.toString() + "\ncol_spacing: " + this.col_spacing + "\nrow_spacing: " + this.row_spacing + "\nforce_shrink: " + this.force_shrink + "\nmargin_width: " + this.margin_width + "\nmargin_height: " + this.margin_height + " ]";
    }

    public Object clone() {
        TableLayout elem = new TableLayout();
        elem.force_shrink = this.force_shrink;
        elem.col_spacing = this.col_spacing;
        elem.row_spacing = this.row_spacing;
        elem.layout = (TableLoc)this.layout.clone();
        elem.same_width = (Vector)this.same_width.clone();
        elem.same_height = (Vector)this.same_height.clone();
        elem.margin_width = this.margin_width;
        elem.margin_height = this.margin_height;
        elem.considerSameWidth();
        elem.considerSameHeight();
        elem.cols = new TableCol(this);
        elem.rows = new TableRow(this);
        return elem;
    }
}

