/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.tablelayout;

import uk.co.westhawk.tablelayout.TableLayout;
import uk.co.westhawk.tablelayout.TableLoc;
import uk.co.westhawk.tablelayout.TableLocRec;
import uk.co.westhawk.tablelayout.TableVec;
import uk.co.westhawk.tablelayout.TableVecRec;

public class TableRow
extends TableVec {
    private static final String version_id = "@(#)$Id: TableRow.java,v 3.1 2001/03/22 13:15:47 birgit Exp $ Copyright West Consulting bv";

    public TableRow(TableLayout tw) {
        this.parent = tw;
        TableLoc loc = this.parent.layout;
        if ((TableLoc)null == loc) {
            return;
        }
        this.size = loc.numRows();
        if (0 == this.size) {
            return;
        }
        this.vec = new TableVecRec[this.size];
        int index = 0;
        while (index < this.size) {
            this.vec[index] = new TableVecRec();
            ++index;
        }
        this.minimize();
    }

    public void minimize() {
        int slot;
        int first_slot;
        TableLocRec rec;
        TableLoc loc = this.parent.layout;
        int loc_sz = loc.size();
        int index = 0;
        while (index < loc_sz) {
            rec = loc.recElementAt(index);
            boolean minimize = rec.options.H;
            boolean dontStretch = rec.options.h;
            first_slot = rec.row;
            int last_slot = rec.row + rec.row_span;
            if (minimize) {
                slot = first_slot;
                while (slot < last_slot) {
                    this.vec[slot].options |= 1;
                    ++slot;
                }
            }
            if (dontStretch) {
                slot = first_slot;
                while (slot < last_slot) {
                    this.vec[slot].options |= 2;
                    ++slot;
                }
            }
            ++index;
        }
        loc.qsort(0, loc_sz - 1, false);
        int i = 0;
        while (i < this.size) {
            this.vec[i].value = 0;
            ++i;
        }
        index = 0;
        while (index < loc_sz) {
            int pref;
            rec = loc.recElementAt(index);
            if (rec.row_span == 1) {
                pref = rec.preferredHeight();
                if (pref > this.vec[rec.row].value) {
                    this.vec[rec.row].value = pref;
                }
            } else {
                int to_stretch;
                int can_stretch = 0;
                int span_size = this.parent.row_spacing * (rec.row_span - 1);
                first_slot = rec.row;
                int stop_before = rec.row + rec.row_span;
                slot = first_slot;
                while (slot < stop_before) {
                    if (0 == (this.vec[slot].options & 2)) {
                        ++can_stretch;
                    }
                    span_size += this.vec[slot].value;
                    ++slot;
                }
                if (0 == can_stretch) {
                    to_stretch = rec.row_span;
                    pref = rec.orig_height;
                } else {
                    to_stretch = can_stretch;
                    pref = rec.preferredHeight();
                }
                if (span_size < pref) {
                    int excess = pref - span_size;
                    int amt = excess / to_stretch;
                    int truncated = excess - amt * to_stretch;
                    slot = first_slot;
                    while (slot < stop_before) {
                        if (0 == can_stretch || 0 == (this.vec[slot].options & 2)) {
                            if (truncated != 0) {
                                this.vec[slot].value += amt + 1;
                                --truncated;
                            } else {
                                this.vec[slot].value += amt;
                            }
                        }
                        ++slot;
                    }
                }
            }
            ++index;
        }
        i = 0;
        while (i < this.size) {
            this.vec[i].pref_value = this.vec[i].value;
            ++i;
        }
    }

    public int totalSize() {
        return this.layoutSize(true);
    }

    public int getPreferredSize() {
        return this.layoutSize(false);
    }

    public int layoutSize(boolean do_actual) {
        int laysize = 0;
        int space = this.parent.row_spacing;
        laysize += 2 * this.parent.margin_height;
        if (do_actual) {
            laysize -= space;
            int slot = 0;
            while (slot < this.size) {
                laysize += this.vec[slot].value + space;
                ++slot;
            }
        } else {
            laysize -= space;
            int slot = 0;
            while (slot < this.size) {
                laysize += this.vec[slot].pref_value + space;
                ++slot;
            }
        }
        if (laysize > 0) {
            return laysize;
        }
        return 1;
    }

    public String toString() {
        String st = new String("TableRow [" + super.toString() + " ] ");
        return st;
    }
}

